#script to generate nonegu2_SmokeFlatFile_POINT_202402.csv input file for Stu's RELPT.sub and point.sub code

#############################################################################################################################
#install libraries
install.packages("plyr")
library(plyr)
install.packages("dplyr")
library(dplyr)
install.packages("readr")
library(readr)
install.packages("psych")
library(psych)
install.packages("ggplot2")
library(ggplot2)
install.packages("ggpubr")
library(ggpubr)
install.packages("geosphere")
library(geosphere)
install.packages("data.table")
library(data.table)

#############################################################################################################################
#set working directory
setwd ("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Gen_RELPT_input/spreadsheets/output")

#############################################################################################################################
#read prepared .csv files
GHGRP_NEI_refineries_matched <- read_csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_GHGRP_NEI_IND/spreadsheets/output/manual_check/GHGRP_NEI_refineries_matched.csv")
GHGRP_NEI_chemicals_matched <- read_csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_GHGRP_NEI_IND/spreadsheets/output/manual_check/GHGRP_NEI_chemicals_matched.csv")
GHGRP_NEI_minerals_metals_matched  <- read_csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Match_GHGRP_NEI_IND/spreadsheets/output/manual_check/GHGRP_NEI_minerals_metals_matched.csv")
IND_template <- read_csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Gen_RELPT_input/spreadsheets/input/nonegu2_SmokeFlatFile_POINT_20200412.csv")

#############################################################################################################################
GHGRP_NEI_refineries_matched_FACILITY_ID = subset(GHGRP_NEI_refineries_matched,select = "NEI_FACILITY_ID")
GHGRP_NEI_chemicals_matched_FACILITY_ID = subset(GHGRP_NEI_chemicals_matched,select = "NEI_FACILITY_ID")
GHGRP_NEI_minerals_metals_matched_FACILITY_ID = subset(GHGRP_NEI_minerals_metals_matched,select = "NEI_FACILITY_ID")

GHGRP_NEI_matched_FACILITY_ID = rbind(GHGRP_NEI_refineries_matched_FACILITY_ID, GHGRP_NEI_chemicals_matched_FACILITY_ID, GHGRP_NEI_minerals_metals_matched_FACILITY_ID)

#############################################################################################################################
IND_others_template = IND_template %>% filter(!(IND_template$facility_id %in% GHGRP_NEI_matched_FACILITY_ID$NEI_FACILITY_ID))

#############################################################################################################################
# Write CSV
fwrite(IND_others_template, "nonegu2_SmokeFlatFile_POINT_202402.csv")

#############################################################################################################################
#double check
IND_out <- read_csv("C:/Users/clyu/Desktop/GHG_CO2/Improving_inventory/V7_GRA2PES2021/Gen_RELPT_input/spreadsheets/output/nonegu2_SmokeFlatFile_POINT_202402.csv", col_types = cols(oris_boiler_id = "d"))
all_equal(IND_others_template,IND_out) #TRUE